﻿/// <reference name="MicrosoftAjax.js">
Number.parseLocaleFixed = function(value) {
    return Number.parseLocale(value.replace(" "," "));
} 

Type.registerNamespace("Localization.Controls");
Localization.Controls.CurrencyTextBox = function(element)
{
    Localization.Controls.CurrencyTextBox.initializeBase(this, [element]);
    this._focusDelegate = null;
    this._blurDelegate = null;
    this._unFormattedValue = null;
};

Localization.Controls.CurrencyTextBox.prototype = {
    get_unFormattedValue: function() { 
        /// <summary>Returns the non-formatted value.</summary>
        /// <returns type="String"></returns>
        return this._unFormattedValue; 
    },
    
    set_unFormattedValue: function(value) { 
        /// <summary>Sets the non-formatted value.</summary>
        /// <param name="value" type="String"></param>
        this._unFormattedValue = value; 
    },
    
    initialize: function() {
        /// <summary>Initializes the control. 
        /// Wiring up event handlers to the blur and focus events.<summary />
        Localization.Controls.CurrencyTextBox.callBaseMethod(this, 'initialize');
        
        var elm = this.get_element();

        // set the formatted value to an initial value if provided.
        if (this._unFormattedValue !== null && this._unFormattedValue !== "") {
           this._format(this._unFormattedValue, elm);
        }
        
        // create and wire the focus and blur delegates to the element.
        this._focusDelegate = Function.createDelegate(this, this._onFocus);
        this._blurDelegate = Function.createDelegate(this, this._onBlur);
                
        $addHandler(elm, "focus", this._focusDelegate);
        $addHandler(elm, "blur", this._blurDelegate);
    },
    
    dispose: function() {
        /// <summary>Remove Events</summary>
        $clearHandlers(this.get_element());
        this._focusDelegate = null;
        this._blurDelegate = null;
        Localization.Controls.CurrencyTextBox.callBaseMethod(this, 'dispose');
    },
    
    _format: function(value, elm) {
        /// <summary> Replace the textbox's value with the formatted value. </summary>
        /// <param name="value" type="String"></param>
        var parsedNumber = Number.parseLocaleFixed(value);
        if (!isNaN(parsedNumber)) {
            elm.value = parsedNumber.localeFormat("c");
            return true;
        }
        return false;
    },
    
    _onFocus: function(args) {
        /// <summary>
        /// Replace the textbox's value with the non-formatted value. 
        /// Selects the textbox's value.
        /// </summary>
        /// <param name="args" type="DomEvent"></param>
        if (this._unFormattedValue !== null) {
            var elm = this.get_element();
            elm.value = this._unFormattedValue;
            elm.select();
        }
    },
    
    _onBlur: function(args) {
        /// <summary>Convert textbox's value to currency</summary>
        /// <param name="args" type="DomEvent"></param>
        var elm = this.get_element();
        var textBoxValue = elm.value;
        
        // update the non-formatted value.
        this._unFormattedValue = textBoxValue;

        if (textBoxValue !== null && textBoxValue !== "") {
            if (!this._format(textBoxValue, elm)) {
                alert (String.format(CurrencyTextBox.Res.InvalidNumberMessage, textBoxValue));
            }
        }
    }
};

Localization.Controls.CurrencyTextBox.registerClass("Localization.Controls.CurrencyTextBox", Sys.UI.Control);